/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.config;

import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.ITypeAdapter;
import net.minecraftforge.common.config.Property;

class TypeAdapters {
    static ITypeAdapter bool = new TypeAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), 1.getBoolean(instance, field), comment);
        }

        @Override
        public Object getValue(Property prop) {
            return prop.getBoolean();
        }
    };
    static ITypeAdapter boolA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), (boolean[])2.getObject(instance, field), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, (boolean[])value, null);
        }

        @Override
        public Object getValue(Property prop) {
            return prop.getBooleanList();
        }
    };
    static ITypeAdapter Bool = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), (Boolean)3.getObject(instance, field), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, (Boolean)value, null);
        }

        @Override
        public Object getValue(Property prop) {
            return prop.getBoolean();
        }
    };
    static ITypeAdapter BoolA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), Booleans.toArray(Arrays.asList((Boolean[])4.getObject(instance, field))), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, (Boolean)value, null);
        }

        @Override
        public Object getValue(Property prop) {
            return Booleans.asList((boolean[])prop.getBooleanList()).toArray(new Boolean[prop.getBooleanList().length]);
        }
    };
    static ITypeAdapter flt = new TypeAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), 5.getFloat(instance, field), comment);
        }

        @Override
        public Object getValue(Property prop) {
            return Float.valueOf((float)prop.getDouble());
        }
    };
    static ITypeAdapter fltA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), Doubles.toArray((Collection)Floats.asList((float[])((float[])6.getObject(instance, field)))), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, Doubles.toArray((Collection)Floats.asList((float[])((float[])value))), null);
        }

        @Override
        public Object getValue(Property prop) {
            return Floats.toArray((Collection)Doubles.asList((double[])prop.getDoubleList()));
        }
    };
    static ITypeAdapter Flt = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), ((Float)7.getObject(instance, field)).floatValue(), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, ((Float)value).floatValue(), null);
        }

        @Override
        public Object getValue(Property prop) {
            return Float.valueOf((float)prop.getDouble());
        }
    };
    static ITypeAdapter FltA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), Doubles.toArray(Arrays.asList((Float[])8.getObject(instance, field))), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, Doubles.toArray(Arrays.asList((Float[])value)), null);
        }

        @Override
        public Object getValue(Property prop) {
            return Floats.asList((float[])Floats.toArray((Collection)Doubles.asList((double[])prop.getDoubleList()))).toArray(new Float[prop.getDoubleList().length]);
        }
    };
    static ITypeAdapter dbl = new TypeAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), 9.getDouble(instance, field), comment);
        }

        @Override
        public Object getValue(Property prop) {
            return prop.getDouble();
        }
    };
    static ITypeAdapter dblA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), (double[])10.getObject(instance, field), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, (double[])value, null);
        }

        @Override
        public Object getValue(Property prop) {
            return prop.getDoubleList();
        }
    };
    static ITypeAdapter Dbl = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), (Double)11.getObject(instance, field), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, (Double)value, null);
        }

        @Override
        public Object getValue(Property prop) {
            return prop.getDouble();
        }
    };
    static ITypeAdapter DblA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), Doubles.toArray(Arrays.asList((Double[])12.getObject(instance, field))), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, Doubles.toArray(Arrays.asList((Double[])value)), null);
        }

        @Override
        public Object getValue(Property prop) {
            return Doubles.asList((double[])prop.getDoubleList()).toArray(new Double[prop.getDoubleList().length]);
        }
    };
    static ITypeAdapter byt = new TypeAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), 13.getByte(instance, field), comment, -128, 127);
        }

        @Override
        public Object getValue(Property prop) {
            return (byte)prop.getInt();
        }
    };
    static ITypeAdapter bytA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), Ints.toArray((Collection)Bytes.asList((byte[])((byte[])14.getObject(instance, field)))), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, Ints.toArray((Collection)Bytes.asList((byte[])((byte[])value))), (String)null);
        }

        @Override
        public Object getValue(Property prop) {
            return Bytes.toArray((Collection)Ints.asList((int[])prop.getIntList()));
        }
    };
    static ITypeAdapter Byt = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), ((Byte)15.getObject(instance, field)).byteValue(), comment, -128, 127);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, ((Byte)value).byteValue(), (String)null, -128, 127);
        }

        @Override
        public Object getValue(Property prop) {
            return (byte)prop.getInt();
        }
    };
    static ITypeAdapter BytA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), Ints.toArray(Arrays.asList((Byte[])16.getObject(instance, field))), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, Ints.toArray(Arrays.asList((Byte[])value)), (String)null);
        }

        @Override
        public Object getValue(Property prop) {
            return Bytes.asList((byte[])Bytes.toArray((Collection)Ints.asList((int[])prop.getIntList()))).toArray(new Byte[prop.getIntList().length]);
        }
    };
    static ITypeAdapter chr = new TypeAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), 17.getChar(instance, field), comment, 0, 65535);
        }

        @Override
        public Object getValue(Property prop) {
            return Character.valueOf((char)prop.getInt());
        }
    };
    static ITypeAdapter chrA = new MapAdapter(){

        private int[] toPrim(char[] v) {
            if (v == null) {
                return new int[0];
            }
            int[] ret = new int[v.length];
            for (int x = 0; x < v.length; ++x) {
                ret[x] = v[x];
            }
            return ret;
        }

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), this.toPrim((char[])18.getObject(instance, field)), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, this.toPrim((char[])value), (String)null);
        }

        @Override
        public Object getValue(Property prop) {
            int[] v = prop.getIntList();
            char[] ret = new char[v.length];
            for (int x = 0; x < v.length; ++x) {
                ret[x] = (char)v[x];
            }
            return ret;
        }
    };
    static ITypeAdapter Chr = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), ((Character)19.getObject(instance, field)).charValue(), comment, 0, 65535);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, ((Character)value).charValue(), (String)null, 0, 65535);
        }

        @Override
        public Object getValue(Property prop) {
            return Character.valueOf((char)prop.getInt());
        }
    };
    static ITypeAdapter ChrA = new MapAdapter(){

        private int[] toPrim(Character[] v) {
            if (v == null) {
                return new int[0];
            }
            int[] ret = new int[v.length];
            for (int x = 0; x < v.length; ++x) {
                ret[x] = v[x] == null ? 0 : (int)v[x].charValue();
            }
            return ret;
        }

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), this.toPrim((Character[])20.getObject(instance, field)), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, this.toPrim((Character[])value), (String)null);
        }

        @Override
        public Object getValue(Property prop) {
            int[] v = prop.getIntList();
            Character[] ret = new Character[v.length];
            for (int x = 0; x < v.length; ++x) {
                ret[x] = Character.valueOf((char)v[x]);
            }
            return ret;
        }
    };
    static ITypeAdapter shrt = new TypeAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), 21.getShort(instance, field), comment, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
        }

        @Override
        public Object getValue(Property prop) {
            return (short)prop.getInt();
        }
    };
    static ITypeAdapter shrtA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), Ints.toArray((Collection)Shorts.asList((short[])((short[])22.getObject(instance, field)))), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, Ints.toArray((Collection)Shorts.asList((short[])((short[])value))), (String)null);
        }

        @Override
        public Object getValue(Property prop) {
            return Shorts.toArray((Collection)Ints.asList((int[])prop.getIntList()));
        }
    };
    static ITypeAdapter Shrt = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), ((Short)23.getObject(instance, field)).shortValue(), comment, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, ((Short)value).shortValue(), (String)null, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
        }

        @Override
        public Object getValue(Property prop) {
            return (short)prop.getInt();
        }
    };
    static ITypeAdapter ShrtA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), Ints.toArray(Arrays.asList((Short[])24.getObject(instance, field))), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, Ints.toArray(Arrays.asList((Short[])value)), (String)null);
        }

        @Override
        public Object getValue(Property prop) {
            int[] v = prop.getIntList();
            Short[] ret = new Short[v.length];
            for (int x = 0; x < ret.length; ++x) {
                ret[x] = (short)v[x];
            }
            return ret;
        }
    };
    static ITypeAdapter int_ = new TypeAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), 25.getInt(instance, field), comment, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public Object getValue(Property prop) {
            return prop.getInt();
        }
    };
    static ITypeAdapter intA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), (int[])26.getObject(instance, field), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, (int[])value, (String)null);
        }

        @Override
        public Object getValue(Property prop) {
            return prop.getIntList();
        }
    };
    static ITypeAdapter Int = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), (Integer)27.getObject(instance, field), comment, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, (Integer)value, null, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public Object getValue(Property prop) {
            return prop.getInt();
        }
    };
    static ITypeAdapter IntA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), Ints.toArray(Arrays.asList((Integer[])28.getObject(instance, field))), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, Ints.toArray(Arrays.asList((Integer[])value)), (String)null);
        }

        @Override
        public Object getValue(Property prop) {
            return Ints.asList((int[])prop.getIntList()).toArray(new Integer[prop.getIntList().length]);
        }
    };
    static ITypeAdapter.Map Str = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), (String)29.getObject(instance, field), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, (String)value, null);
        }

        @Override
        public Object getValue(Property prop) {
            return prop.getString();
        }
    };
    static ITypeAdapter StrA = new MapAdapter(){

        @Override
        public Property getProp(Configuration cfg, String category, Field field, Object instance, String comment) {
            return cfg.get(category, field.getName(), (String[])30.getObject(instance, field), comment);
        }

        @Override
        public Property getProp(Configuration cfg, String category, String name, Object value) {
            return cfg.get(category, name, (String[])value, null);
        }

        @Override
        public Object getValue(Property prop) {
            return prop.getStringList();
        }
    };

    TypeAdapters() {
    }

    private static abstract class MapAdapter
    extends TypeAdapter
    implements ITypeAdapter.Map {
        private MapAdapter() {
        }
    }

    private static abstract class TypeAdapter
    implements ITypeAdapter {
        private TypeAdapter() {
        }

        public static boolean getBoolean(Object instance, Field f) {
            try {
                return f.getBoolean(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        public static int getInt(Object instance, Field f) {
            try {
                return f.getInt(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public static Object getObject(Object instance, Field f) {
            try {
                return f.get(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static byte getByte(Object instance, Field f) {
            try {
                return f.getByte(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public static char getChar(Object instance, Field f) {
            try {
                return f.getChar(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                return '\u0000';
            }
        }

        public static double getDouble(Object instance, Field f) {
            try {
                return f.getDouble(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0.0;
            }
        }

        public static float getFloat(Object instance, Field f) {
            try {
                return f.getFloat(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0.0f;
            }
        }

        public static short getShort(Object instance, Field f) {
            try {
                return f.getShort(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }
    }
}

